clear();
clc();
close all;                              %Plots schlieen

%KONFIGURATION---------------------------------------------------------------------
aWERTETABELLE(1,:)  =["Xi", -3,     -2,     -1,    0,   	1,      2,      3];
aWERTETABELLE(2,:)  =["Yi", 749.2,  726.8,  694.7, 669.1,   641.4,  623.8,  606.8];
sKommastellenDouble = '%.12f';           %Nachkommastellen, die in einer Berechnung mitgeschleift werden sollen

%PRUEFUNG--------------------------------------------------------------------------
iANZAHL_WERTE = size(aWERTETABELLE,2)-1;                                            %Gibt die Anzahl der Spalten zurck (Parameter 2) abzglich 1 (Der Bezeichner der Wertereihe)

%INITIALISIERUNG-------------------------------------------------------------------
aLGS(1,1)="0";
aLGS(1,2)="0";
aLGS(1,3)="a";
aLGS(1,4)="0";
aLGS(2,1)="0";
aLGS(2,2)="0";
aLGS(2,3)="b";
aLGS(2,4)="0";

%BERECHNUNG------------------------------------------------------------------------
for(i=1:1:iANZAHL_WERTE)
    aLGS(1,1)=num2str(str2double(aLGS(1,1))+(str2double(aWERTETABELLE(1,i+1))^2),sKommastellenDouble);
    aLGS(1,2)=num2str(str2double(aLGS(1,2))+str2double(aWERTETABELLE(1,i+1)),sKommastellenDouble);
    aLGS(1,4)=num2str(str2double(aLGS(1,4))+(str2double(aWERTETABELLE(2,i+1))*str2double(aWERTETABELLE(1,i+1))),sKommastellenDouble);    
    aLGS(2,1)=num2str(str2double(aLGS(2,1))+str2double(aWERTETABELLE(1,i+1)),sKommastellenDouble);
    aLGS(2,2)=num2str(str2double(aLGS(2,2))+1,sKommastellenDouble);
    aLGS(2,4)=num2str(str2double(aLGS(2,4))+str2double(aWERTETABELLE(2,i+1)),sKommastellenDouble);
end

%AUFLSUNG_NACH_GAU---------------------------------------------------------------
aAUFLOESUNG=aLGS;
IndexErgebnis=size(aAUFLOESUNG,2);

%Pivotisierung
if(str2double(aAUFLOESUNG(2,1)) > str2double(aAUFLOESUNG(1,1)))                     
   Zwischenpeicher=aAUFLOESUNG(1,:);
   aAUFLOESUNG(1,:)=aAUFLOESUNG(2,:);
   aAUFLOESUNG(2,:)=Zwischenpeicher;
end
Quotient = str2double(aAUFLOESUNG(2,1))/str2double(aAUFLOESUNG(1,1));
aAUFLOESUNG(2,1) = num2str(str2double(aAUFLOESUNG(2,1)) - Quotient*str2double(aAUFLOESUNG(1,1)),sKommastellenDouble);
aAUFLOESUNG(2,2) = num2str(str2double(aAUFLOESUNG(2,2)) - Quotient*str2double(aAUFLOESUNG(1,2)),sKommastellenDouble);
aAUFLOESUNG(2,IndexErgebnis) = num2str(str2double(aAUFLOESUNG(2,IndexErgebnis)) - Quotient*str2double(aAUFLOESUNG(1,IndexErgebnis)),sKommastellenDouble);

%Rckwrtsauflsung
aX(2,1)=aAUFLOESUNG(2,3);
aX(2,2)="=";
aX(2,3)=num2str(str2double(aAUFLOESUNG(2,IndexErgebnis))/str2double(aAUFLOESUNG(2,2)),sKommastellenDouble);
aX(1,1)=aAUFLOESUNG(1,3);
aX(1,2)="=";
aX(1,3)=num2str((str2double(aAUFLOESUNG(1,IndexErgebnis))-(str2double(aAUFLOESUNG(1,2))*str2double(aX(2,3))))/str2double(aAUFLOESUNG(1,1)),sKommastellenDouble);

%FORMATIERUNG_AUSGANGSGLEICHUNG---------------------------------------------------
F(1,:)=["f(x)=","a","*x","+b"];
if(aX(1,1)=="a")
    a=str2double(aX(1,3));
    b=str2double(aX(2,3));
else
    a=str2double(aX(2,3));
    b=str2double(aX(1,3));
end
F(2,:)=["f(x)=",a,"*x",b];

%ERGEBNISPLOT----------------------------------------------------------------------
xACHSE              = @(x) 0*x;
Inkrement=100;
X=min(str2double(aWERTETABELLE(1,2:end))):(max(str2double(aWERTETABELLE(1,2:end)))-min(str2double(aWERTETABELLE(1,2:end))))/Inkrement:max(str2double(aWERTETABELLE(1,2:end)));
Y                   = @(x) (a*x)+b;
scatter(aWERTETABELLE(1,2:end),aWERTETABELLE(2,2:end),100,'o');
hold on;                                %Warten bis zur Plotausgabe
Offset=0.1;
text(str2double(aWERTETABELLE(1,2:end))+Offset,str2double(aWERTETABELLE(2,2:end))+Offset,cellstr(strcat(aWERTETABELLE(1,2:end)," | ",aWERTETABELLE(2,2:end))));
hold on;                                %Warten bis zur Plotausgabe
plot(X,Y(X),'color','blue');
text(X(1)+Offset,Y(X(1))-1,cellstr(strcat("y=",num2str(a),"*x+",num2str(b))));
hold on;                                %Warten bis zur Plotausgabe
plot(X,xACHSE(X),'color','black');
grid on;                                %Warten bis zur Plotausgabe
grid minor;

%PROGRAMMENDE----------------------------------------------------------------------
clearvars -except aWERTETABELLE aLGS aAUFLOESUNG aX F                          %Workspace aufrumen